//---------------------------------------------------------//
//                                                         //
//               Marijus Verbolauskas, 1gr.               //
//               Binarinis paiekos medis                  //
//                                                         //
//---------------------------------------------------------//

#include <iostream>
#include <cstdlib>
using namespace std;

class BinarySearchTree
{
    private:                           
        struct treeNode
        {
           treeNode* left;
           treeNode* right;
           int data;
        };
        treeNode* root;
    
    public:                            
        BinarySearchTree()
        {
           root = NULL;
        }
       
        bool isEmpty() const { return root==NULL; }
        void printInorder();
        void inorder(treeNode*);
        void printPreorder();
        void preorder(treeNode*);
        void printPostorder();
        void postorder(treeNode*);
        void insert(int);
        void remove(int);
};

//------------------------------------------------------------------------------

void BinarySearchTree::insert(int d)
{
    treeNode* t = new treeNode;
    treeNode* parent;
    t->data = d;
    t->left = NULL;
    t->right = NULL;
    parent = NULL;
    
    if(isEmpty()) root = t;
    else
    {
        treeNode* curr;
        curr = root;

        while(curr)
        {
            parent = curr;
            if(t->data > curr->data) curr = curr->right;
            else curr = curr->left;
        }

        if(t->data < parent->data)
           parent->left = t;
        else
           parent->right = t;
    }
}

//------------------------------------------------------------------------------
void BinarySearchTree::remove(int d)
{
    bool found = false;
    if(isEmpty())
    {
        cout << "|------------------------------------------------------------|" << endl;
        cout << "| MEDIS YRA TUSCIAS                                          |" << endl;
        cout << "|------------------------------------------------------------|" << endl;
        return;
    }
    
    treeNode* curr;
    treeNode* parent;
    curr = root;
    
    while(curr != NULL)
    {
         if(curr->data == d)
         {
            found = true;
            break;
         }
         else
         {
             parent = curr;
             if(d>curr->data) curr = curr->right;
             else curr = curr->left;
         }
    }
    if(!found)
		 {
        cout << "" << endl;      
        cout << " Elemento, kuri ieskote  nera. " << endl;
        return;
    }

    if((curr->left == NULL && curr->right != NULL)|| (curr->left != NULL
    && curr->right == NULL))
    {
       if(curr->left == NULL && curr->right != NULL)
       {
           if(parent->left == curr)
           {
             parent->left = curr->right;
             delete curr;
           }
           else
           {
             parent->right = curr->right;
             delete curr;
           }
       }
       else 
       {
          if(parent->left == curr)
           {
             parent->left = curr->left;
             delete curr;
           }
           else
           {
             parent->right = curr->left;
             delete curr;
           }
       }
     return;
    }
		  
		 if( curr->left == NULL && curr->right == NULL)
    {
        if(parent->left == curr) parent->left = NULL;
        else parent->right = NULL;
		 		 delete curr;
		 		 return;
    }

    if (curr->left != NULL && curr->right != NULL)
    {
        treeNode* chkr;
        chkr = curr->right;
        if((chkr->left == NULL) && (chkr->right == NULL))
        {
            curr = chkr;
            delete chkr;
            curr->right = NULL;
        }
        else 
        {
            
            if((curr->right)->left != NULL)
            {
                treeNode* lcurr;
                treeNode* lcurrp;
                lcurrp = curr->right;
                lcurr = (curr->right)->left;
                while(lcurr->left != NULL)
                {
                   lcurrp = lcurr;
                   lcurr = lcurr->left;
                }
		curr->data = lcurr->data;
                delete lcurr;
                lcurrp->left = NULL;
           }
           else
           {
               treeNode* tmp;
               tmp = curr->right;
               curr->data = tmp->data;
	       curr->right = tmp->right;
               delete tmp;
           }

        }
		 return;
    }

}

//------------------------------------------------------------------------------
void BinarySearchTree::printInorder()
{
  inorder(root);
}

//------------------------------------------------------------------------------
void BinarySearchTree::inorder(treeNode* p)
{
    if(p != NULL)
    {
        if(p->left) inorder(p->left);
        cout<<" "<<p->data<<" ";
        if(p->right) inorder(p->right);
    }
    else return;
}

//------------------------------------------------------------------------------
void BinarySearchTree::printPreorder()
{
    preorder(root);
}

//------------------------------------------------------------------------------
void BinarySearchTree::preorder(treeNode* p)
{
    if(p != NULL)
    {
        cout<<" "<<p->data<<" ";
        if(p->left) preorder(p->left);
        if(p->right) preorder(p->right);
    }
    else return;
}

//------------------------------------------------------------------------------
void BinarySearchTree::printPostorder()
{
    postorder(root);
}

//------------------------------------------------------------------------------
void BinarySearchTree::postorder(treeNode* p)
{
    if(p != NULL)
    {
        if(p->left) postorder(p->left);
        if(p->right) postorder(p->right);
        cout<<" "<<p->data<<" ";
    }
    else return;
}

//------------------------------------------------------------------------------
int main()
{
    BinarySearchTree b;
    int ch,tmp,tmp1;
    while(1)
    {
       cout<<endl<<endl;
       cout <<" |-------------------------------------------------------------| "<< endl;
       cout <<" | 1. Iterpimas/Sukurimas                                      | "<< endl;
       cout <<" | 2. Medis infiksine tvarka                                   | "<< endl;
       cout <<" | 3. Medis prefiksine tvarka                                  | "<< endl;
       cout <<" | 4. Medis postfiksine tvarka                                 | "<< endl;
       cout <<" | 5. Elemento naikinimas                                      | "<< endl;
       cout <<" |-------------------------------------------------------------| "<< endl;
       cout <<" | 0. Baigti darba                                             | "<< endl;
       cout <<" |-------------------------------------------------------------| "<< endl;
       cout <<""<<endl;
       cout <<"   ";
       cin>>ch;
       switch(ch)
       {
           case 1 : cout<< " " << endl;
                    cout<<"   Skaicius, kuri norima iterpti: ";
                    cin>>tmp;
                    b.insert(tmp);
                    cout <<" " <<endl;
                    cout <<" |-------------------------|" <<endl;
                    cout <<" |    Skaicius iterptas    |" <<endl;
                    cout <<" |-------------------------|" <<endl;
                    break;
           case 2 : cout<<endl;
                    cout<<"   Medis infiksine tvarka "<<endl;
                    cout<<"   ----------------------"<<endl;
                    b.printInorder();
                    break;
           case 3 : cout<<endl;
                    cout<<"   Medis prefiksine tvarka "<<endl;
                    cout<<"   -----------------------"<<endl;
                       b.printPreorder();
                    break;
           case 4 : cout<<endl;
                    cout<<"   Medis postfiksine tvarka "<<endl;
                    cout<<"   ------------------------"<<endl;
                    b.printPostorder();
                    break;
           case 5 : cout<<"   Skaicius, kuri norite istrinti: ";
                    cin>>tmp;
                    b.remove(tmp);
                    cout<<"   Skaicius istrintas ";
                    break;
           case 0 : 
                    return 0;
                    
       }
    }
}
